(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17992,        711]*)
(*NotebookOutlinePosition[     18832,        738]*)
(*  CellTagsIndexPosition[     18788,        734]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Subsection"],

Cell[StyleData[All, "Working"],
  CellBracketOptions->{"Color"->RGBColor[0, 0.2, 1]},
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Subsection"],

Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            OptionValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            OptionValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellLabelAutoDelete->False,
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Headings", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{12, Inherited}, {2, 20}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->30,
  FontWeight->"Bold"],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{2, 10}, {2, 30}},
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{12, Inherited}, {2, 2}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {2, 4}},
  FontSize->18,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{12, Inherited}, {2, 12}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 0.6]],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{2, 10}, {2, 8}},
  FontSize->12,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {2, 0}},
  CellMargins->{{10, 4}, {2, 50}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{2, 4}, {2, 80}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{24, 4}, {2, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->12},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->15,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{2, 4}, {2, 18}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{10, 4}, {2, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->12},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Helvetica",
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{2, 4}, {2, 18}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{10, 4}, {0, 8}},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
  CellFrame->{{4, 0}, {0, 0}},
  CellMargins->{{47, 62}, {0, 14}},
  CellFrameMargins->5,
  CellFrameColor->RGBColor[0, 0.2, 1],
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 8},
  FontColor->RGBColor[0, 0, 0.6]],

Cell[StyleData["MathCaption", "Printout"],
  CellMargins->{{34, 62}, {0, 14}},
  CellFrameColor->GrayLevel[0.700008],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input/Output", "Subsection"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{56, 4}, {3, 9}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{42, 4}, {3, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{57, 4}, {5, 2}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->StandardForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{42, 4}, {4, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{56, 4}, {3, 8}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0.2, 1]],

Cell[StyleData["Message", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{42, 4}, {4, 2}},
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{56, 4}, {3, 8}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{42, 4}, {4, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{56, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{40, 4}, {4, 2}},
  ImageSize->{250, 250},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0.2, 1]],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->7,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["TextTop"],
  CellFrame->{{0, 0}, {0, 2}},
  CellMargins->{{10, 4}, {2, 80}},
  CellHorizontalScrolling->True,
  CellFrameMargins->4,
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text"],

Cell[StyleData["TextTop", "Printout"],
  CellMargins->{{2, 4}, {2, 80}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedText"],
  CellMargins->{{20, 4}, {0, 8}},
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 8},
  ParagraphIndent->-15,
  CounterIncrements->"Text"],

Cell[StyleData["ItemizedText", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote"],
  CellMargins->{{35, 4}, {0, 4}},
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 4},
  CounterIncrements->"Text"],

Cell[StyleData["ItemizedTextNote", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndentedText"],
  CellMargins->{{20, 4}, {0, 6}},
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text"],

Cell[StyleData["IndentedText", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Note"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text",
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["Note", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["1ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["1ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.39, 0.59}}],

Cell[StyleData["2ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnSmallBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.35,
  ColumnAlignments->{Right, Left}}],

Cell[StyleData["2ColumnSmallBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->0.325}],

Cell[StyleData["3ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnSmallBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.23,
  ColumnAlignments->{Right, Center, Left}}],

Cell[StyleData["3ColumnSmallBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["4ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.145, 0.345, 0.145, 0.345}}],

Cell[StyleData["4ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->0.195}],

Cell[StyleData["5ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.13, 0.23, 0.13, 0.13, 0.23, 0.13}}],

Cell[StyleData["6ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
  CellMargins->{{10, Inherited}, {0, 8}},
  CellHorizontalScrolling->True],

Cell[StyleData["Picture", "Printout"],
  CellMargins->{{2, Inherited}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{10, 50}, {0, 3}},
  PageBreakAbove->False,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{2, 50}, {2, 4}},
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["2ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  GridBoxOptions->{ColumnWidths->{0.39, 0.59},
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnTable", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.325,
  ColumnAlignments->{Left}}],

Cell[StyleData["3ColumnTable", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{42, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Printout"],
  CellMargins->{{34, Inherited}, {Inherited, Inherited}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{42, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  ScriptLevel->0,
  SingleLetterItalics->True,
  SpanMaxSize->Infinity,
  UnderoverscriptBoxOptions->{LimitsPositioning->True},
  GridBoxOptions->{ColumnWidths->Automatic}],

Cell[StyleData["DisplayFormula", "Printout"],
  CellMargins->{{34, Inherited}, {Inherited, Inherited}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  FontFamily->"Courier"],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{2, Inherited}, {Inherited, Inherited}},
  FontSize->9.5]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{481, 307},
WindowMargins->{{11, Automatic}, {Automatic, 2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 62, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 45, 0, 46, "Subsection"],
Cell[2037, 63, 105, 2, 36, 31, 0, "StyleData", "All", "Working"],
Cell[2145, 67, 104, 2, 36, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2286, 74, 38, 0, 30, "Subsection"],
Cell[2327, 76, 105, 3, 30, "Text"],
Cell[2435, 81, 538, 14, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3010, 100, 30, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[3065, 104, 346, 9, 68, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3414, 115, 87, 2, 73, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3538, 122, 347, 9, 55, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[3888, 133, 116, 3, 40, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4041, 141, 350, 9, 45, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4394, 152, 119, 3, 39, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4550, 160, 378, 10, 64, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4931, 172, 88, 2, 122, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5056, 179, 396, 11, 45, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[5455, 192, 91, 2, 49, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5583, 199, 278, 7, 43, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[5864, 208, 94, 2, 47, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6007, 216, 26, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[6058, 220, 114, 3, 36, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[6175, 225, 84, 2, 35, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6296, 232, 244, 7, 40, 30, 0, "StyleData", "MathCaption", "All"],
Cell[6543, 241, 160, 4, 41, 42, 0, "StyleData", "MathCaption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6752, 251, 34, 0, 30, "Subsection"],
Cell[6789, 253, 252, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[7066, 262, 436, 13, 42, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[7505, 277, 112, 3, 37, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7654, 285, 423, 12, 37, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[8080, 299, 113, 3, 33, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8230, 307, 479, 14, 35, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[8712, 323, 141, 4, 33, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8890, 332, 441, 13, 35, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[9334, 347, 112, 3, 33, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9483, 355, 389, 11, 36, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[9875, 368, 113, 3, 32, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10025, 376, 130, 4, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[10158, 382, 106, 3, 31, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10313, 391, 35, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[10373, 395, 241, 7, 116, 26, 0, "StyleData", "TextTop", "All",
  CounterIncrements->"Text"],
Cell[10617, 404, 88, 2, 115, 38, 0, "StyleData", "TextTop", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10742, 411, 182, 5, 32, 31, 0, "StyleData", "ItemizedText", "All",
  CounterIncrements->"Text"],
Cell[10927, 418, 59, 1, 35, 43, 0, "StyleData", "ItemizedText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11023, 424, 162, 4, 32, 35, 0, "StyleData", "ItemizedTextNote", "All",
  CounterIncrements->"Text"],
Cell[11188, 430, 63, 1, 31, 47, 0, "StyleData", "ItemizedTextNote", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11288, 436, 158, 4, 32, 31, 0, "StyleData", "IndentedText", "All",
  CounterIncrements->"Text"],
Cell[11449, 442, 59, 1, 70, 43, 0, "StyleData", "IndentedText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11545, 448, 245, 8, 47, 23, 0, "StyleData", "Note", "All",
  CounterIncrements->"Text"],
Cell[11793, 458, 83, 2, 48, 35, 0, "StyleData", "Note", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11913, 465, 256, 7, 48, 29, 0, "StyleData", "1ColumnBox", "All"],
Cell[12172, 474, 125, 3, 51, 41, 0, "StyleData", "1ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12334, 482, 265, 7, 48, 29, 0, "StyleData", "2ColumnBox", "All"],
Cell[12602, 491, 125, 3, 51, 41, 0, "StyleData", "2ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12764, 499, 320, 9, 48, 34, 0, "StyleData", "2ColumnSmallBox", "All"],
Cell[13087, 510, 130, 3, 51, 46, 0, "StyleData", "2ColumnSmallBox", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13254, 518, 258, 7, 48, 29, 0, "StyleData", "3ColumnBox", "All"],
Cell[13515, 527, 125, 3, 51, 41, 0, "StyleData", "3ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13677, 535, 328, 9, 48, 34, 0, "StyleData", "3ColumnSmallBox", "All"],
Cell[14008, 546, 130, 3, 51, 46, 0, "StyleData", "3ColumnSmallBox", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14175, 554, 281, 7, 48, 29, 0, "StyleData", "4ColumnBox", "All"],
Cell[14459, 563, 125, 3, 51, 41, 0, "StyleData", "4ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14621, 571, 258, 7, 48, 29, 0, "StyleData", "5ColumnBox", "All"],
Cell[14882, 580, 125, 3, 51, 41, 0, "StyleData", "5ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15044, 588, 289, 7, 48, 29, 0, "StyleData", "6ColumnBox", "All"],
Cell[15336, 597, 125, 3, 51, 41, 0, "StyleData", "6ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15498, 605, 101, 2, 32, 26, 0, "StyleData", "Picture", "All"],
Cell[15602, 609, 79, 1, 36, 38, 0, "StyleData", "Picture", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15718, 615, 128, 4, 30, 26, 0, "StyleData", "Caption", "All"],
Cell[15849, 621, 87, 2, 29, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15985, 629, 28, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[16038, 633, 174, 4, 36, 31, 0, "StyleData", "2ColumnTable", "All"],
Cell[16215, 639, 92, 2, 35, 43, 0, "StyleData", "2ColumnTable", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16344, 646, 193, 5, 40, 31, 0, "StyleData", "3ColumnTable", "All",
  StyleMenuListing->None],
Cell[16540, 653, 92, 2, 35, 43, 0, "StyleData", "3ColumnTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16681, 661, 46, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[16752, 665, 306, 8, 36, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[17061, 675, 120, 2, 35, 46, 0, "StyleData", "ChemicalFormula", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[17218, 682, 342, 8, 36, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[17563, 692, 119, 2, 35, 45, 0, "StyleData", "DisplayFormula", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[17719, 699, 118, 3, 32, 26, 0, "StyleData", "Program", "All"],
Cell[17840, 704, 112, 2, 35, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

